package gov.va.med.mhv.admin.web.formbean;

import java.io.Serializable;
import java.util.List;

import javax.faces.bean.ManagedBean;
import javax.faces.bean.SessionScoped;

import gov.va.med.mhv.admin.dto.EmployeeOrgRoleDTO;
import gov.va.med.mhv.admin.dto.EmployeeSearchResult;

@ManagedBean(name = "staffSearchResults")
@SessionScoped
public class SearchResultsFormBean implements Serializable {

	private static final long serialVersionUID = -6609294959864644809L;

	List<EmployeeSearchResult> employees = null;
	List<EmployeeOrgRoleDTO> roles = null;
	ManagedStaffMember managed = null;
	CameFrom cameFrom = null;
	int activeIndexValue = 0;

	public int getActiveIndexValue() {
		return activeIndexValue;
	}

	public void setActiveIndexValue(int activeIndexValue) {
		this.activeIndexValue = activeIndexValue;
	}

	public enum CameFrom {
		SEARCH, VIEW_ALL
	}

	public List<EmployeeSearchResult> getEmployees() {
		return employees;
	}

	public void setEmployees(List<EmployeeSearchResult> employees) {
		this.employees = employees;
	}

	public List<EmployeeOrgRoleDTO> getRoles() {
		return roles;
	}

	public void setRoles(List<EmployeeOrgRoleDTO> roles) {
		this.roles = roles;
	}

	public ManagedStaffMember getManaged() {
		return managed;
	}

	public void setManaged(ManagedStaffMember managed) {
		this.managed = managed;
	}

	public CameFrom getCameFrom() {
		return cameFrom;
	}

	public void setCameFrom(CameFrom cameFrom) {
		this.cameFrom = cameFrom;
	}

	public void clearEmployee() {
		if (managed != null) {
			managed.clearEmployeeData();
		}
	}
}
